
/* Includes ---------------------------------------------------------------- */
#include <gest_inferencing.h>
#include <Wire.h>
#include <LSM303AGR_ACC_Sensor.h>
#include "edge-impulse-sdk/classifier/ei_run_classifier.h"

#define CONVERT_G_TO_MS2    9.80665f
#define FREQUENCY_HZ        50
#define INTERVAL_MS         (1000 / (FREQUENCY_HZ + 1))

static unsigned long last_interval_ms = 0;
LSM303AGR_ACC_Sensor Acc(&Wire);

// Buffer for accelerometer data
float features[EI_CLASSIFIER_DSP_INPUT_FRAME_SIZE] = { 0 };
int feature_index = 0;

void setup() {
    Serial.begin(115200);
    Serial.println("Started");

    Wire.begin();
    Acc.begin();
    Acc.Enable();
    Serial.println("LSM303 Accelerometer initialized");
}

void loop() {
    int32_t accelerometer[3];
    
    if (millis() > last_interval_ms + INTERVAL_MS) {
        last_interval_ms = millis();

        // Read accelerometer data
        Acc.GetAxes(accelerometer);

        // Convert to m/s^2
        features[feature_index++] = accelerometer[0] * CONVERT_G_TO_MS2 / 1000.0f;
        features[feature_index++] = accelerometer[1] * CONVERT_G_TO_MS2 / 1000.0f;
        features[feature_index++] = accelerometer[2] * CONVERT_G_TO_MS2 / 1000.0f;




   
        // Check if buffer is full
        if (feature_index >= EI_CLASSIFIER_DSP_INPUT_FRAME_SIZE) {
            // Run inference
            signal_t signal;
            int err = numpy::signal_from_buffer(features, EI_CLASSIFIER_DSP_INPUT_FRAME_SIZE, &signal);
            if (err != 0) {
                Serial.println("Failed to create signal!");
                return;
            }

            ei_impulse_result_t result = { 0 };
            EI_IMPULSE_ERROR res = run_classifier(&signal, &result, false);

            if (res != EI_IMPULSE_OK) {
                Serial.println("Error running classifier!");
                return;
            }

            // Print results
            Serial.println("Predictions:");
            for (size_t ix = 0; ix < EI_CLASSIFIER_LABEL_COUNT; ix++) {
                Serial.print(result.classification[ix].label);
                Serial.print(": ");
                Serial.println(result.classification[ix].value);
            }

            // Reset feature index
            feature_index = 0;
        }
    }
}
